#include <iostream>
#include <string>
#include <array>
#include <cmath>

constexpr int N_MAX = 1'048'576;
constexpr int Q_MAX = 500'000;

constexpr int BROJ = N_MAX + 10;

struct Opcija {
    int miljenik, broj_promena;  // broj_promena - najveci dozvoljeni broj promena
};

std::array<int, N_MAX> igraci;
std::array<int, N_MAX> igraci_tmp;

int nadji_index(int clan, int n)
{
    for (int i = 0; i < n; i++)
    {
        if (igraci[i] == clan) {
            return i;
        }
    }

    return 0;
}

constexpr int suma(int stepen, int n)
{
    return (int)(( 0.5 * (1 - std::pow(0.5, stepen)) ) / (0.5)) * n;
}

int koj_deo(int indeks, int stepen, int n)
{
    int pow = std::pow(2, stepen);
    int indeks_tmp = indeks / (n - pow) * (n - pow);
    
    int sum = suma(stepen, n);

    if (indeks_tmp >= sum)
    {
        return sum - (int)(std::pow(0.5, stepen) * n);
    }
    else
    {
        return sum;
    }
}

int main(int argc, char const *argv[])
{
    std::ios_base::sync_with_stdio(false);

    int n, q;
    std::cin >> n;

    for (int i = 0; i < n; i++)
    {
        std::cin >> igraci[i];
    }

    std::cin >> q;

    std::string ispis;  // tdo: da odmah dodelim velicinu

    for (int k = 0; k < q; k++)
    {
        std::copy(igraci.begin(), igraci.begin() + n, igraci_tmp.begin());

        int miljenik, broj_promena;

        std::cin >> miljenik >> broj_promena;
        int indeks = miljenik - 1;
        miljenik = igraci[indeks];

        if (miljenik == n)
        {
            ispis += std::to_string((int)log2(n) + 1) + '\n';
            continue;
        }

        bool izadji = false;
        // int indeks = nadji_index(miljenik, n);

        for (int i = 1; i <= log2(n); i++)
        {
            if (i == miljenik)
            {
                ispis += std::to_string(i) + '\n';
                break;
            }

            int pow = std::pow(2, i), pocetni_indeks = (indeks / pow) * pow;

            for (int j = pocetni_indeks; j < pocetni_indeks + pow; j++)
            {
                if (igraci_tmp[j] > miljenik)
                {
                    if (broj_promena == 0)
                    {
                        ispis += std::to_string(i) + '\n';
                        izadji = true;
                        break;
                    }
                    
                    broj_promena--;
                    
                    // int kd = koj_deo(indeks, i, n);
                    // for (int f = kd; f < kd + n/pow; f++)
                    // {
                    //     if (igraci_tmp[f] < igraci_tmp[j])
                    //     {
                    //         std::swap(igraci_tmp[f], igraci_tmp[j]);
                    //     }
                    // }
                    
                    for (int f = 0; f < n; f++)
                    {
                        if (igraci_tmp[f] < igraci_tmp[j])
                        {
                            std::swap(igraci_tmp[f], igraci_tmp[j]);
                            break;
                        }
                    }
                }
            }

            if (izadji)
            {
                break;
            }
        }
    }

    std::cout << ispis;

    return 0;
}